<?php

/*
 * byteShard
 *
 * @category   byteShard Framework
 * @package    byteShard
 * @copyright  Copyright (c) 2009 - 2015 Bespin Studios GmbH - All Rights Reserved
 * @license    Unauthorized copying of this file, via any medium is strictly prohibited. Proprietary and confidential
 * @author     Lars Hennig <lars@bespin-studios.com>, January 2015
 * @version    1.0
 */

use byteShard\Environment;
use byteShard\Internal\ByteShard;
use byteShard\Internal\ErrorHandler\Template;

if (file_exists(BS_VENDOR_AUTOLOAD)) {
    require_once BS_VENDOR_AUTOLOAD;
} else {
    // TODO do something if autoloader does not exist
    file_put_contents('php://stderr', 'composer autoloader does not exist, please make sure that the file vendor/autoload.php exists');
    return;
}

require_once BS_FILE_PRIVATE_ROOT . '/config.php';

$config        = new config();
$byteShard     = new ByteShard($config);
$env           = $byteShard->init();
$error_handler = $byteShard->getErrorHandler();

if ($env instanceof Environment) {
    // override the line formatter with the application log formatter
    $logFormatter = $env->getLogFormatter();
    if ($logFormatter !== null) {
        $byteShard->setLogFormatter($env->getLogFormatter());
    }
    // set the global db driver
    $dbDriver = $env->getDbDriver();

    if ($setup === false) {
        // Authenticate
        $env->authenticate();
    }
} else {
    Template::printInvalidEnvironmentTemplate();
}
