<?php

namespace Bespin\DocumentType;

use OpenApi\Attributes\Property;
use OpenApi\Attributes\Schema;

#[Schema]
class Tag
{
    #[Property]
    public int    $tagId;
    #[Property]
    public string $tag;

    /**
     * @param array<string, string|int> $data
     * @return self|null
     */
    public static function create(array $data): ?self
    {
        if (empty($data)) {
            return null;
        }
        $self = new self();
        if (array_key_exists('tag', $data) && is_string($data['tag'])) {
            $self->tag = $data['tag'];
        }
        if (array_key_exists('tagId', $data) && is_int($data['tagId'])) {
            $self->tagId = $data['tagId'];
        }
        return $self;
    }
}
