<?php /** @noinspection PhpUnused */

namespace Bespin\DocumentType;

use JsonSerializable;
use OpenApi\Attributes\Items;
use OpenApi\Attributes\Property;
use OpenApi\Attributes\Schema;

#[Schema]
class Document implements JsonSerializable
{
    #[Property]
    public int     $documentId;
    #[Property]
    public ?string $documentDate;
    #[Property]
    public string  $documentType;
    #[Property]
    public ?string $documentSender;
    #[Property]
    public ?string $referenceNumber;
    #[Property]
    public int     $sourceId;
    #[Property]
    public int     $vendorEmailId;
    #[Property]
    public string  $createdOn;
    #[Property]
    public string  $md5;
    #[Property]
    public string  $url;
    #[Property]
    public bool    $unread;
    /** @var array<int, Tag> */
    #[Property(items: new Items(type: "string"))]
    public array         $tags = [];
    public ?string       $storageProvider;
    public ?string       $jsonTags;
    public ?DocumentType $type;

    /**
     * @return array<string, mixed>
     */
    public function jsonSerialize(): array
    {
        /**
         * @var array{'type': ?DocumentType, 'jsonTags': ?string, 'storageProvider': ?string, 'tags': array<int, Tag>} $result
         */
        $result = get_object_vars($this);
        unset($result['storageProvider']);
        $result['documentType'] = $result['type']?->value ?? '';
        unset ($result['type']);
        if (!empty($result['jsonTags']) && $result['jsonTags'] !== '[null]' && empty($result['tags'])) {
            $tags = json_decode($result['jsonTags']);
            if (is_array($tags)) {
                $result['tags'] = $tags;
            }
        }
        unset($result['jsonTags']);
        return $result;
    }

    public static function create(mixed $data): ?self
    {
        if (empty($data) || !is_array($data)) {
            return null;
        }
        $self = new self();
        foreach ($data as $property => $value) {
            switch ($property) {
                case 'tags':
                    if (is_array($value)) {
                        foreach ($value as $tagProperties) {
                            if (!empty($tagProperties)) {
                                $tag = Tag::create($tagProperties);
                                if ($tag !== null) {
                                    $self->tags[$tag->tagId] = $tag;
                                }
                            }
                        }
                    }
                    break;
                case 'documentType':
                    $self->documentType = $value;
                    $self->type         = DocumentType::tryFrom($value);
                    break;
                default:
                    $self->{$property} = $value;
                    break;
            }
        }
        return $self;
    }
}
