<?php

namespace Bespin\DocumentType;

use DateTime;

class ToDo
{
    public int       $todoId;
    public string    $todo            = '';
    public int       $typeString;
    public ToDoType  $type;
    public ?string   $dueDateString   = null;
    public ?DateTime $dueDate         = null;
    public ?string   $createdOnString = null;
    public ?DateTime $createdOn       = null;
    public ?int      $createdBy       = null;

    public function __construct()
    {
        if (!empty($this->typeString)) {
            $this->type = ToDoType::from($this->typeString);
        }
        if (!empty($this->dueDateString)) {
            $this->dueDate = new DateTime($this->dueDateString);
        }
        if (!empty($this->createdOnString)) {
            $this->createdOn = new DateTime($this->createdOnString);
        }
    }

    /**
     * @param array<string, int|string> $data
     * @return self|null
     */
    public static function create(array $data): ?self
    {
        if (empty($data)) {
            return null;
        }
        $self = new self();
        if (array_key_exists('todoId', $data) && is_int($data['todoId'])) {
            $self->todoId = $data['todoId'];
        }
        if (array_key_exists('todo', $data) && is_string($data['todo'])) {
            $self->todo = $data['todo'];
        }
        if (array_key_exists('typeString', $data) && is_int($data['typeString'])) {
            $self->type = ToDoType::from($data['typeString']);
        }
        if (array_key_exists('dueDateString', $data) && is_string($data['dueDateString'])) {
            $dueDate = DateTime::createFromFormat('Y-m-d H:i:s', $data['dueDateString']);
            if ($dueDate !== false) {
                $self->dueDate = $dueDate;
            }
        }
        if (array_key_exists('createdOnString', $data) && is_string($data['createdOnString'])) {
            $createdOn = DateTime::createFromFormat('Y-m-d H:i:s', $data['createdOnString']);
            if ($createdOn !== false) {
                $self->createdOn = $createdOn;
            }
        }
        if (array_key_exists('createdBy', $data) && is_int($data['createdBy'])) {
            $self->createdBy = $data['createdBy'];
        } else {
            $self->createdBy = null;
        }
        return $self;
    }
}
