<?php

namespace Bespin\DocumentType;

enum DocumentType: int
{
    case UNDEFINED = 1;
    case PAYROLL = 2;
    case WAGE_TAX = 3;
    case INVOICE = 4;
    case MIXED = 5;
    case ACCOUNT_STATEMENT = 6;
    case CORRESPONDENCE = 7;
    case BILL = 8;
    case CREDIT = 9;
    case REPORT = 10;
    case REPORT_SIGNED = 11;
    case QUOTE = 13;
    case ORDER = 14;

    public function name(): string
    {
        return match ($this) {
            DocumentType::UNDEFINED         => 'undefined',
            DocumentType::PAYROLL           => 'payroll',
            DocumentType::WAGE_TAX          => 'wageTax',
            DocumentType::INVOICE           => 'invoice',
            DocumentType::MIXED             => 'mixed',
            DocumentType::ACCOUNT_STATEMENT => 'accountStatement',
            DocumentType::CORRESPONDENCE    => 'correspondence',
            DocumentType::BILL              => 'bill',
            DocumentType::CREDIT            => 'credit',
            DocumentType::REPORT            => 'report',
            DocumentType::REPORT_SIGNED     => 'reportSigned',
            DocumentType::QUOTE             => 'quote',
            DocumentType::ORDER             => 'order'
        };
    }

    public static function get(string $type): self
    {
        return match ($type) {
            'undefined'        => DocumentType::UNDEFINED,
            'payroll'          => DocumentType::PAYROLL,
            'wageTax'          => DocumentType::WAGE_TAX,
            'invoice'          => DocumentType::INVOICE,
            'mixed'            => DocumentType::MIXED,
            'accountStatement' => DocumentType::ACCOUNT_STATEMENT,
            'correspondence'   => DocumentType::CORRESPONDENCE,
            'bill'             => DocumentType::BILL,
            'credit'           => DocumentType::CREDIT,
            'report'           => DocumentType::REPORT,
            'reportSigned'     => DocumentType::REPORT_SIGNED,
            'quote'            => DocumentType::QUOTE,
            'order'            => DocumentType::ORDER
        };
    }
}
