<?php

namespace Bespin\DocumentType;

enum DocumentType: int
{
    //TODO: check if this can be changed to string
    case UNDEFINED = 1;
    case PAYROLL = 2;
    case WAGE_TAX = 3;
    case INVOICE = 4;
    case MIXED = 5;
    case ACCOUNT_STATEMENT = 6;
    case CORRESPONDENCE = 7;
    case BILL = 8;
    case CREDIT = 9;
    case REPORT = 10;
    case REPORT_SIGNED = 11;
    case QUOTE = 13;
    case ORDER = 14;
    case SICK_NOTE = 15;

    public function name(): string
    {
        return match ($this) {
            self::UNDEFINED         => 'undefined',
            self::PAYROLL           => 'payroll',
            self::WAGE_TAX          => 'wageTax',
            self::INVOICE           => 'invoice',
            self::MIXED             => 'mixed',
            self::ACCOUNT_STATEMENT => 'accountStatement',
            self::CORRESPONDENCE    => 'correspondence',
            self::BILL              => 'bill',
            self::CREDIT            => 'credit',
            self::REPORT            => 'report',
            self::REPORT_SIGNED     => 'reportSigned',
            self::QUOTE             => 'quote',
            self::ORDER             => 'order',
            self::SICK_NOTE         => 'sickNote'
        };
    }

    public static function get(string $type): self
    {
        return match ($type) {
            'undefined'        => self::UNDEFINED,
            'payroll'          => self::PAYROLL,
            'wageTax'          => self::WAGE_TAX,
            'invoice'          => self::INVOICE,
            'mixed'            => self::MIXED,
            'accountStatement' => self::ACCOUNT_STATEMENT,
            'correspondence'   => self::CORRESPONDENCE,
            'bill'             => self::BILL,
            'credit'           => self::CREDIT,
            'report'           => self::REPORT,
            'reportSigned'     => self::REPORT_SIGNED,
            'quote'            => self::QUOTE,
            'order'            => self::ORDER,
            'sickNote'         => self::SICK_NOTE
        };
    }
}
