<?php /** @noinspection PhpUnused */

namespace Bespin\DocumentType;

use JsonSerializable;
use OpenApi\Attributes\Items;
use OpenApi\Attributes\Property;
use OpenApi\Attributes\Schema;

#[Schema]
class Document implements JsonSerializable
{
    #[Property]
    public int           $documentId;
    #[Property]
    public ?string       $documentDate;
    #[Property]
    public string        $documentType;
    #[Property]
    public ?string       $documentSender;
    #[Property]
    public ?string       $referenceNumber;
    #[Property]
    public int           $sourceId;
    #[Property]
    public int           $vendorEmailId;
    #[Property]
    public string        $createdOn;
    #[Property]
    public string        $md5;
    #[Property]
    public string        $url;
    #[Property(items: new Items(type: "string"))]
    public array         $tags = [];
    public ?string       $storageProvider;
    public ?string       $jsonTags;
    public ?DocumentType $type;

    public function jsonSerialize(): array
    {
        $result = get_object_vars($this);
        unset($result['storageProvider']);
        $result['documentType'] = $result['type']?->value ?? '';
        unset ($result['type']);
        if (!empty($result['jsonTags']) && $result['jsonTags'] !== '[null]' && empty($result['tags'])) {
            $tags = json_decode($result['jsonTags']);
            if (is_array($tags)) {
                $result['tags'] = $tags;
            }
        }
        unset($result['jsonTags']);
        return $result;
    }

    public static function create(array $data): self
    {
        $self = new self();
        foreach ($data as $property => $value) {
            switch ($property) {
                case 'tags':
                    foreach ($value as $tag) {
                        $self->tags[] = Tag::create($tag);
                    }
                    break;
                case 'documentType':
                    $self->documentType = $value;
                    $self->type         = DocumentType::tryFrom($value);
                    break;
                default:
                    $self->{$property} = $value;
                    break;
            }
        }
        return $self;
    }
}
