<?php

namespace Bespin\DocumentClient;

use Exception;
use DateTimeInterface;
use Bespin\DocumentClient\Helper\Rest;
use Bespin\DocumentType\Document;
use Bespin\DocumentType\DocumentType;

class Documents
{
    private string $url;
    private string $bearer;

    public function __construct(string $url, string $bearer)
    {
        $this->url    = $url;
        $this->bearer = $bearer;
    }

    /**
     * @return array<int, Document>
     * @throws Exception
     */
    public function getDocuments(
        int                $userId,
        array              $groupIds = [],
        ?DateTimeInterface $from = null,
        ?DateTimeInterface $to = null,
        ?DateTimeInterface $createdAfter = null,
        ?bool              $inbox = false,
        array              $tags = [],
        ?int               $rangeFrom = null,
        ?int               $rangeTo = null,
        DocumentType       ...$types): array
    {
        $parameters = ['userId' => $userId];
        foreach ($groupIds as $groupId) {
            $parameters['groupIds'][] = $groupId;
        }
        foreach ($types as $type) {
            $parameters['types'][] = $type->name();
        }
        if ($from !== null) {
            $parameters['from'] = $from->format('Y-m-d');
        }
        if ($to !== null) {
            $parameters['to'] = $to->format('Y-m-d');
        }
        if ($createdAfter !== null) {
            $parameters['createdAfter'] = $createdAfter->format('Y-m-d H:i:s');
        }
        if ($inbox === true) {
            $parameters['inbox'] = true;
        }
        if (!empty($tags)) {
            $parameters['tags'] = $tags;//json_encode($tags);
        }
        $headers = ['AUTHORIZATION: '.$this->bearer];
        if ($rangeFrom !== null) {
            $headers[] = 'RANGE: documents='.$rangeFrom.($rangeTo !== null ? '-'.$rangeTo : '');
        }
        $documents = Rest::read($this->url, 'documents', $parameters, $headers, true);
        if (empty($documents)) {
            return $documents;
        }
        $result = [];
        foreach ($documents as $document) {
            $result[$document['documentId']] = Document::create($document);
        }
        return $result;
    }

    public function getNumberOfInboxDocuments(int $userId, array $groupIds = []): int
    {
        //TODO: get the http header from the response to get the total number on inbox documents
        $result = $this->getDocuments(userId: $userId, groupIds: $groupIds, inbox: true, rangeFrom: 0);
        return 0;
    }
}
