<?php

namespace Bespin\DocumentClient;

use Bespin\DocumentClient\Helper\Rest;

class Inspect
{
    public function __construct(private readonly string $url, private readonly string $bearer)
    {

    }

    public function inspectDocument(int $documentId, int $ownerId, array $groupIds = []): void
    {
        Rest::create(
            endpoint  : $this->url,
            location  : 'inspect',
            parameters: ['id' => $documentId, 'ownerId' => $ownerId, 'groupIds' => $groupIds],
            headers   : ['AUTHORIZATION: '.$this->bearer]);
    }
}