<?php

namespace Bespin\DocumentClient\File;

use CURLFile;
use CURLStringFile;
use DateTime;

class StringFile implements FileInterface
{
    public function __construct(
        private readonly string    $contents,
        private readonly string    $fileName,
        private readonly ?DateTime $documentDate = null)
    {

    }

    public function getFileName(): string
    {
        return $this->fileName;
    }

    public function getDocumentDate(): ?DateTime
    {
        return $this->documentDate;
    }

    public function getCurlFile(): CURLFile|CURLStringFile
    {
        return new CURLStringFile($this->contents, $this->fileName);
    }
}