<?php

namespace Bespin\DocumentClient\Helper;

use CURLFile;

class StringFile
{
    private string $path;
    private string $mimeType;

    public function __construct(string $content) {
        $this->path = tempnam(sys_get_temp_dir(), 'documentClient');
        file_put_contents($this->path, $content);
        $this->mimeType = mime_content_type($this->path);
    }

    public function getCurlFile(): CURLFile
    {
        return new CURLFile($this->path, $this->mimeType);
    }

    public function getMimeType(): string
    {
        return $this->mimeType;
    }

    public function __destruct()
    {
        if ($this->path !== '') {
            unlink($this->path);
        }
    }
}
