<?php

namespace Bespin\DocumentClient;

use Bespin\DocumentClient\Exception\NotFoundException;
use Bespin\DocumentClient\Exception\PermissionDeniedException;
use Bespin\DocumentClient\Helper\BodyTransform;
use Bespin\DocumentClient\Helper\Rest;
use Exception;

class Pdf
{
    /**
     * @param string $url the url of the pdf service
     */
    public function __construct(private readonly string $url)
    {

    }

    /**
     * @param string $url the url of the website of which a pdf should be generated
     * @param array $getParameters
     * @return string
     * @throws NotFoundException
     * @throws PermissionDeniedException
     * @throws Exception
     */
    public function getPdf(string $url, array $getParameters = []): string
    {
        $parameters['url'] = $url;
        if (!empty($getParameters)) {
            $parameters['get_parameters'] = $getParameters;
        }

        $headers = [
            'Content-Length: '.strlen(json_encode($parameters)),
            'Content-Type: application/json'
        ];
        return Rest::curl(
            endpoint  : $this->url,
            method    : 'POST',
            parameters: $parameters,
            headers   : $headers,
            transform : BodyTransform::JSON_ENCODE);
    }
}