<?php

namespace Bespin\DocumentClient\DocumentType;

use Bespin\DocumentClient\File\FileInterface;
use Bespin\DocumentType\DocumentType;
use DateTime;

class DatevSocialSecurity extends Document
{
    public function __construct(FileInterface $document, int $ownerId, ?DateTime $contentDate)
    {
        parent::__construct($document, $ownerId);
        $title = 'Meldebescheinigung zur Sozialversicherung'.($contentDate !== null ? ' '.$contentDate->format('Y') : '');
        $this->setReference($title);
        $this->setSender('DATEV');
        $this->setDocumentType(DocumentType::DATEV_SOCIAL_SECURITY_ANNUAL);
        $this->setDocumentDate($document->getDocumentDate());
    }
}
