<?php

namespace Bespin\DocumentClient;

use Bespin\DocumentClient\Exception\NotFoundException;
use Bespin\DocumentClient\Exception\PermissionDeniedException;
use Bespin\DocumentClient\Helper\BodyTransform;
use Bespin\DocumentClient\Helper\Rest;
use Exception;

class Pdf
{
    /**
     * @param string $url the url of the pdf service
     */
    public function __construct(private readonly string $url)
    {

    }

    /**
     * @param string $url the url of the website of which a pdf should be generated
     * @param array<int, string> $getParameters
     * @return string
     * @throws NotFoundException
     * @throws PermissionDeniedException
     * @throws Exception
     */
    public function getPdf(string $url, array $getParameters = []): string
    {
        $parameters['url'] = $url;
        if (!empty($getParameters)) {
            $parameters['get_parameters'] = $getParameters;
        }

        $content       = json_encode($parameters);
        $contentLength = $content === false ? 0 : strlen($content);
        $headers       = [
            'Content-Length: '.$contentLength,
            'Content-Type: application/json'
        ];
        $apiResult     = Rest::curl(
            endpoint  : $this->url,
            method    : 'POST',
            parameters: $parameters,
            headers   : $headers,
            transform : BodyTransform::JSON_ENCODE);
        return is_string($apiResult) ? $apiResult : '';
    }
}
