<?php

namespace Bespin\DocumentClient\DocumentType;

use Bespin\DocumentClient\File\FileInterface;
use Bespin\DocumentType\DocumentType;
use DateTime;

class DatevHealthInsurance extends Document
{
    public function __construct(FileInterface $document, int $ownerId, DateTime $contentDate)
    {
        $title = 'Krankenkasse Beitragsabrechnung '.$contentDate->format('m/Y');
        parent::__construct($document, $ownerId);
        $this->setReference($title);
        $this->setSender('DATEV');
        $this->setDocumentType(DocumentType::DATEV_HEALTH_INSURANCE);
        $this->setDocumentDate($document->getDocumentDate());
    }
}
