<?php

namespace Bespin\DocumentClient\DocumentType;

use Bespin\DocumentClient\File\FileInterface;
use Bespin\DocumentType\DocumentType;
use DateTime;

class Payroll extends EmployeeDocument
{
    public function __construct(FileInterface $document, int $ownerId, object $employee, DateTime $contentDate, string $suffix = '')
    {
        if ($suffix !== '') {
            $suffix = ' '.$suffix;
        }
        $title = 'Lohnabrechnung '.$contentDate->format('m/Y').$suffix;
        parent::__construct($document, $ownerId, $employee, $title);
        $this->setDocumentType(DocumentType::PAYROLL);
        $this->setDocumentDate($document->getDocumentDate());
    }
}
