<?php

namespace Bespin\DocumentClient\DocumentType;

use Bespin\DocumentClient\File\FileInterface;
use Bespin\DocumentType\DocumentType;
use DateTime;

class DatevProtocolPayrollDeclaration extends Document
{
    public function __construct(FileInterface $document, int $ownerId, DateTime $contentDate)
    {
        $title = 'Protokoll Lohnsteueranmeldung '.$contentDate->format('m/Y');
        parent::__construct($document, $ownerId);
        $this->setReference($title);
        $this->setSender('DATEV');
        $this->setDocumentType(DocumentType::DATEV_PROTOCOL_PAYROLL_DECLARATION);
        $this->setDocumentDate($document->getDocumentDate());
    }
}
