<?php

namespace Bespin\DocumentClient\Model;


use Bespin\DocumentClient\DocumentType\EmployeeDocument;
use Bespin\DocumentClient\DocumentType\InvoiceDocument;
use DateTime;

interface ParserModelInterface
{
    public function employeeDocumentExists(int $userId, string $title, DateTime $documentDate): bool;

    public function storeEmployeeDocument(EmployeeDocument $document, int $documentId, int $approvedBy = 0): void;

    public function storeInvoiceDocument(InvoiceDocument $document, int $documentId = 0): int;

    public function getEmployee(int $employeeId): ?object;
}
