<?php

namespace Bespin\DocumentClient\Helper;

trait RequestHeader
{

    /**
     * @return array<string>
     */
    private function getAuthHeader(): array
    {
        $headers = [];
        if (isset($this->bearer)) {
            $headers[] = 'AUTHORIZATION: '.$this->bearer;
        }
        if (isset($_COOKIE['access_token'])) {
            $headers[] = 'X-ACCESS-TOKEN: '.$_COOKIE['access_token'];
        }
        return $headers;
    }

}