<?php

namespace Bespin\DocumentClient\DocumentType;

use Bespin\DocumentClient\File\FileInterface;
use DateTime;

class InvoiceDocument extends Document
{
    private float $value           = 0;
    private float $vatRegular      = 0;
    private float $vatReduced      = 0;
    private int   $vendorId        = 0;
    private int   $purchaseOrderId = 0;

    public function __construct(FileInterface $document)
    {
        parent::__construct($document);
    }

    public function setValue(float $value): void
    {
        $this->value = $value;
    }

    public function setVatRegular(float $vatRegular): void
    {
        $this->vatRegular = $vatRegular;
    }

    public function setVatReduced(float $vatReduced): void
    {
        $this->vatReduced = $vatReduced;
    }

    public function setVendorId(?int $vendorId): void
    {
        if ($vendorId !== null) {
            $this->vendorId = $vendorId;
        }
    }

    public function getValue(): float|int
    {
        return $this->value;
    }

    public function getVatRegular(): float|int
    {
        return $this->vatRegular;
    }

    public function getVatReduced(): float|int
    {
        return $this->vatReduced;
    }

    public function getPurchaseOrderId(): int
    {
        return $this->purchaseOrderId;
    }

    public function getVendorId(): ?int
    {
        return $this->vendorId;
    }

    public function setPurchaseOrderId(?int $purchaseOrderId): void
    {
        if ($purchaseOrderId !== null) {
            $this->purchaseOrderId = $purchaseOrderId;
        }
    }

    public function setInvoiceNumber(string $invoiceNumber)
    {
        $this->setReference($invoiceNumber);
    }

    public function getInvoiceNumber(): string
    {
        return $this->getReference();
    }

    public function getInvoiceDate(): ?DateTime
    {
        return $this->getDocumentDate();
    }
}