<?php

namespace Bespin\DocumentClient\DocumentType;

use Bespin\DocumentClient\File\FileInterface;
use Bespin\DocumentType\DocumentType;
use DateTime;

class DatevHealthInsuranceAllocation extends Document
{
    public function __construct(FileInterface $document, int $ownerId, ?DateTime $contentDate)
    {
        parent::__construct($document, $ownerId);
        $title = 'Krankenkasse Umlagebeiträge'.($contentDate !== null ? ' '.$contentDate->format('m/Y') : '');
        $this->setReference($title);
        $this->setSender('DATEV');
        $this->setDocumentType(DocumentType::DATEV_HEALTH_INSURANCE_ALLOCATION);
        $this->setDocumentDate($document->getDocumentDate());
    }
}
