<?php

namespace Bespin\DocumentClient\DocumentType;

use Bespin\DocumentClient\File\FileInterface;
use Bespin\DocumentType\DocumentType;
use DateTime;

class DatevDeUevRegistration extends Document
{
    public function __construct(FileInterface $document, int $ownerId, ?DateTime $contentDate)
    {
        parent::__construct($document, $ownerId);
        $title = 'DEÜV An-/Abmeldungen'.($contentDate !== null ? ' '.$contentDate->format('m/Y') : '');
        $this->setReference($title);
        $this->setSender('DATEV');
        $this->setDocumentType(DocumentType::DATEV_DEUEV_REGISTRATION);
        $this->setDocumentDate($document->getDocumentDate());
    }
}
