<?php

namespace Bespin\DocumentClient\Parser;

use Bespin\DocumentClient\DocumentType\Document;
use Bespin\DocumentClient\File\FileInterface;
use Bespin\DocumentClient\DocumentType\Bill;
use Bespin\DocumentClient\Model\ParserModelInterface;
use Bespin\DocumentType\DocumentType;

class DocumentParser
{
    private DocumentType $documentType;
    private FileInterface $pdfHandler;

    public function __construct(FileInterface $pdf, DocumentType $documentType = DocumentType::UNDEFINED)
    {
        $this->pdfHandler   = $pdf;
        $this->documentType = $documentType;
    }

    public function determineDocumentContent(): array
    {
        $result = [];
        switch ($this->documentType) {
            case DocumentType::UNDEFINED:
            case DocumentType::MIXED:
                $textContent = $this->pdfHandler->getText();
                if (stripos($textContent, 'datev') !== false) {
                    $datevParser = new DatevParser($this->pdfHandler);
                    $result = array_merge($result, $datevParser->determineDocumentType($textContent));
                }
                if (empty($result)) {
                    $result[DocumentType::UNDEFINED->value] = DocumentType::UNDEFINED;
                }
                break;
            default:
                $result[$this->documentType->value] = $this->documentType;
                break;
        }
        return $result;
    }

    public function getDocuments(ParserModelInterface $parserModel, string $sender, string $reference): array
    {
        $types = $this->determineDocumentContent();
        if (in_array(DocumentType::PAYROLL, $types) || in_array(DocumentType::WAGE_TAX, $types)) {
            $datevParser = new DatevParser($this->pdfHandler);
            return $datevParser->getDocuments($parserModel);
        }
        $result = [];
        foreach ($types as $type) {
            switch ($type) {
                case DocumentType::PAYROLL:
                case DocumentType::WAGE_TAX:
                    break;
                case DocumentType::BILL:
                    $result[] = new Bill($this->pdfHandler);
                    break;
                default:
                    $result[] = new Document($this->pdfHandler);
            }
        }
        foreach ($result as $document) {
            $document->setSender($sender);
            $document->setReference($reference);
        }
        return $result;
    }
}