<?php

namespace Bespin\DocumentClient\DocumentType;

use Bespin\DocumentClient\File\FileInterface;
use Bespin\DocumentType\DocumentType;
use DateTime;

class Document
{
    private string        $sender       = '';
    private string        $reference    = '';
    private FileInterface $document;
    private DocumentType  $documentType = DocumentType::UNDEFINED;
    private bool          $upload       = true;
    private bool          $assigned     = false;
    private ?DateTime     $documentDate = null;

    public function __construct(FileInterface $document, private readonly int $ownerId)
    {
        $this->document = $document;
    }

    public function getOwnerId(): int
    {
        return $this->ownerId;
    }

    public function setDocumentType(DocumentType $documentType): self
    {
        $this->documentType = $documentType;
        return $this;
    }

    public function getFile(): string
    {
        return $this->document->getFileName();
    }

    public function getType(): DocumentType
    {
        return $this->documentType;
    }

    public function getSender(): string
    {
        return $this->sender;
    }

    public function getReference(): string
    {
        return $this->reference;
    }

    public function getDocumentDate(): ?DateTime
    {
        return $this->documentDate;
    }

    public function setDocumentDate(DateTime $date): self
    {
        $this->documentDate = $date;
        return $this;
    }

    public function getTags(): array
    {
        return [];
    }

    public function setReference(string $reference): void
    {
        $this->reference = $reference;
    }

    public function setSender(string $sender): void
    {
        $this->sender = $sender;
    }

    public function getUpload(): bool
    {
        return $this->upload;
    }

    public function getAssigned(): bool
    {
        return $this->assigned;
    }

    public function setAssigned(bool $assigned): void
    {
        $this->assigned = $assigned;
    }

    public function setUpload(bool $upload): void
    {
        $this->upload = $upload;
    }
}