<?php

namespace Bespin\DocumentClient;

use Bespin\DocumentClient\Exception\NotFoundException;
use Bespin\DocumentClient\Exception\PermissionDeniedException;
use Bespin\DocumentClient\Helper\Rest;
use Exception;

class Inspect
{
    public function __construct(private readonly string $url, private readonly string $bearer)
    {

    }

    /**
     * @param array<int> $groupIds
     * @throws NotFoundException
     * @throws PermissionDeniedException
     * @throws Exception
     */
    public function inspectDocument(int $documentId, int $ownerId, array $groupIds = []): void
    {
        Rest::create(
            endpoint  : $this->url,
            location  : 'inspect',
            parameters: ['id' => $documentId, 'ownerId' => $ownerId, 'groupIds' => $groupIds],
            headers   : ['AUTHORIZATION: '.$this->bearer]);
    }
}
