<?php

namespace Bespin\DocumentClient\DocumentType;

use Bespin\DocumentClient\File\FileInterface;
use Bespin\DocumentType\DocumentType;
use DateTime;

class DatevSocialSecurity extends EmployeeDocument
{
    const REGISTRATION    = 10;
    const DE_REGISTRATION = 30;
    const ANNUAL          = 50;

    public function __construct(FileInterface $document, int $ownerId, object $employee, ?DateTime $contentDate, int $type)
    {
        $title = 'Meldebescheinigung zur Sozialversicherung';
        $title .= match ($type) {
            self::REGISTRATION    => ' - Anmeldung '.($contentDate !== null ? ' '.$contentDate->format('d.m.Y') : ''),
            self::DE_REGISTRATION => ' - Abmeldung'.($contentDate !== null ? ' '.$contentDate->format('d.m.Y') : ''),
            self::ANNUAL          => ' - Jahresmeldung'.($contentDate !== null ? ' '.$contentDate->format('Y') : ''),
            default               => ($contentDate !== null ? ' '.$contentDate->format('d.m.Y') : ''),
        };
        parent::__construct($document, $ownerId, $employee, $title);
        $this->setReference($title);
        $this->setSender('DATEV');
        $this->setDocumentType(DocumentType::DATEV_SOCIAL_SECURITY_ANNUAL);
        $this->setDocumentDate($document->getDocumentDate());
    }
}
