<?php

namespace bootstrap;

use Bespin\DocumentClient\File\PdfFile;

class TestFiles
{
    /**
     * @return FileObject[]
     */
    public static function getTestFiles(): array
    {
        $mockData  = json_decode(file_get_contents('testResources/mock.json'));
        $testFiles = [];
        foreach ($mockData as $data) {
            $fileName = 'testResources/'.$data->fileName;
            $file     = null;
            switch ($data->type) {
                case 'pdf':
                    $file = new PdfFile($fileName);
                    break;
            }
            $contents    = $data->contents ?? [];
            $contents = (array)$contents;
            if ($file !== null) {
                $testFiles[] = new FileObject(
                    pages       : $data->pages,
                    file        : $file,
                    testContent : $data->testContent,
                    title       : $data->title,
                    documentDate: $data->documentDate,
                    fileName    : $fileName,
                    documentType: $data->documentType,
                    contents    : $contents
                );
            }
        }
        return $testFiles;
    }
}