<?php

namespace bootstrap;

use Bespin\DocumentClient\DocumentType\EmployeeDocument;
use Bespin\DocumentClient\DocumentType\InvoiceDocument;
use Bespin\DocumentClient\Model\ParserModelInterface;
use DateTime;

class ParserModel implements ParserModelInterface
{
    public function employeeDocumentExists(int $userId, string $title, DateTime $documentDate): bool
    {
        return false;
    }

    public function storeEmployeeDocument(EmployeeDocument $document, int $documentId, int $approvedBy = 0): void
    {
        // TODO: Implement storeEmployeeDocument() method.
    }

    public function storeInvoiceDocument(InvoiceDocument $document, int $documentId = 0): int
    {
        return 0;
    }

    public function getEmployee(int $employeeId): ?object
    {
        if (file_exists('testResources/employee.json')) {
            $users = json_decode(file_get_contents('testResources/mockEmployeeData'));
            $employees = [];
            foreach ($users as $user) {
                $employees[$user->employeeId] = new Employee($user->userId, $user->firstName, $user->lastName);
            }
            if (array_key_exists($employeeId, $employees)) {
                return $employees[$employeeId];
            }
        }
        return null;
    }
}