<?php

namespace Bespin\DocumentClient\Helper;

class Header
{
    /**
     * @var array<string, string>
     */
    private array        $parameters = [];
    private ?ContentType $mimeType   = null;

    /**
     * @param array<string, string> $responseHeaders
     */
    public function __construct(array $responseHeaders)
    {
        if (array_key_exists('content-type', $responseHeaders)) {
            $this->parseContentType($responseHeaders['content-type']);
        }
    }

    private function parseContentType(string $contentType): void
    {
        $parts          = explode(';', $contentType);
        $mimeType       = strtolower(trim(array_shift($parts)));
        $this->mimeType = ContentType::tryFrom(strtolower(trim($mimeType)));

        foreach ($parts as $part) {
            $pair = explode('=', $part, 2);
            if (count($pair) == 2) {
                $this->addContentTypeParameters($pair[0], $pair[1]);
            }
        }
    }

    public function getContentType(): ?ContentType
    {
        return $this->mimeType;
    }

    private function addContentTypeParameters(string $key, string $value): void
    {
        $this->parameters[strtolower(trim($key))] = strtolower(trim($value));
    }

    /**
     * @return array<string, string>
     */
    public function getContentTypeParameters(): array
    {
        return $this->parameters;
    }
}
