<?php

namespace Bespin\DocumentClient\DocumentType;

use Bespin\DocumentClient\File\FileInterface;
use Bespin\DocumentType\DocumentType;
use DateTime;

class DatevSocialSecurity extends EmployeeDocument
{
    public function __construct(FileInterface $document, int $ownerId, object $employee, ?DateTime $contentDate)
    {
        $title = 'Meldebescheinigung zur Sozialversicherung'.($contentDate !== null ? ' '.$contentDate->format('Y') : '');
        parent::__construct($document, $ownerId, $employee, $title);
        $this->setReference($title);
        $this->setSender('DATEV');
        $this->setDocumentType(DocumentType::DATEV_SOCIAL_SECURITY_ANNUAL);
        $this->setDocumentDate($document->getDocumentDate());
    }
}
