<?php

namespace tests\File;

use Bespin\DocumentClient\File\PdfFile;
use PHPUnit\Framework\TestCase;
use bootstrap\FileObject;
use bootstrap\TestFiles;

final class PdfFileTest extends TestCase
{
    /**
     * @var FileObject[]
     */
    private array $files = [];

    public function setUp(): void
    {
        parent::setUp();
        $files = TestFiles::getTestFiles();
        foreach ($files as $file) {
            if ($file->file instanceof PdfFile) {
                $this->files[] = $file;
            }
        }
    }

    public function testNumberOfPages(): void
    {
        foreach ($this->files as $page) {
            $this->assertSame($page->pages, $page->file->getNumberOfPages());
        }
    }

    public function testText(): void
    {
        foreach ($this->files as $file) {
            $text = $file->file->getText();
            $this->assertStringContainsString($file->testContent, $text);
        }
    }

    public function testDocumentDate(): void
    {
        foreach ($this->files as $file) {
            $date = $file->file->getDocumentDate();
            if ($date !== null) {
                $this->assertSame($file->documentDate, $date->format('Y-m-d H:i:s'));
            }
        }
    }

    public function testDocumentTitle(): void
    {
        foreach ($this->files as $file) {
            $title = $file->file->getDocumentTitle();
            $this->assertSame($file->title, $title);
        }
    }

    public function testFileName(): void
    {
        foreach ($this->files as $file) {
            $fileName = $file->file->getFileName();
            $this->assertSame($file->fileName, $fileName);
        }
    }
}