<?php

namespace Bespin\DocumentClient\DocumentType;

use Bespin\DocumentClient\File\FileInterface;
use Bespin\DocumentType\DocumentType;
use DateTime;

class SickNote extends Document
{
    public function __construct(FileInterface $document, int $ownerId, string $employeeName, ?DateTime $determinedOn)
    {
        parent::__construct($document, $ownerId);
        $this->setDocumentType(DocumentType::SICK_NOTE);
        $this->setSender($employeeName);
        if ($determinedOn !== null) {
            $this->setDocumentDate($determinedOn);
        }
    }
}
