<?php

namespace Bespin\DocumentClient\DocumentType;

use Bespin\DocumentClient\File\FileInterface;

class EmployeeDocument extends Document
{
    private int $userId;

    public function __construct(FileInterface $document, object $employee, string $title)
    {
        parent::__construct($document);
        $this->userId = $employee->userId;
        $this->setSender($employee->lastName.','.$employee->firstName);
        $this->setReference($title);
    }

    public function getUserId(): int
    {
        return $this->userId;
    }

    public function getTitle(): string
    {
        return $this->getReference();
    }

}