<?php

namespace Bespin\DocumentClient\DocumentType;

use Bespin\DocumentClient\File\FileInterface;
use Bespin\DocumentType\DocumentType;
use DateTime;

class DatevProtocolStatementOfContribution extends Document
{
    public function __construct(FileInterface $document, int $ownerId, DateTime $contentDate)
    {
        $title = 'Protokoll Beitragsnachweis '.$contentDate->format('m/Y');
        parent::__construct($document, $ownerId);
        $this->setReference($title);
        $this->setSender('DATEV');
        $this->setDocumentType(DocumentType::DATEV_PROTOCOL_STATEMENT_OF_CONTRIBUTION);
        $this->setDocumentDate($document->getDocumentDate());
    }
}
