<?php

namespace tests\Parser;

use Bespin\DocumentClient\DocumentType\Document;
use Bespin\DocumentClient\File\PdfFile;
use Bespin\DocumentClient\Parser\DocumentParser;
use Bespin\DocumentType\DocumentType;
use bootstrap\ParserModel;
use bootstrap\TestFiles;
use PHPUnit\Framework\TestCase;

class DocumentParserTest extends TestCase
{
    private array $pages;

    public function setUp(): void
    {
        parent::setUp();
        $this->pages = TestFiles::getTestFiles();
    }

    public function testDocumentType(): void
    {
        foreach ($this->pages as $page) {
            $parser       = new DocumentParser($page->file);
            $documentType = $parser->determineDocumentContent();
            $this->assertSame($page->documentType, $documentType->name);
        }
    }

    public function testDatevContentSplitting(): void
    {
        foreach ($this->pages as $page) {
            $parser       = new DocumentParser($page->file);
            $documentType = $parser->determineDocumentContent();
            if ($documentType === DocumentType::DATEV_PAYROLL_ACCOUNTING) {
                $documents = $parser->getDocuments(new ParserModel(), '', '');
                /** @var Document $file */
                foreach ($documents as $file) {
                    $fileName = str_replace(['/', ' ', ','], '_', implode('_', array_filter([$file->getReference(), $file->getSender()])));
                    if (array_key_exists($fileName, $page->contents)) {
                        $pdf = new PdfFile($file->getFile());
                        $this->assertSame($pdf->getNumberOfPages(), $page->contents[$fileName]->pages);
                    }
                }
            }
        }
    }
}