<?php

namespace Bespin\DocumentClient\DocumentType;

use Bespin\DocumentClient\File\FileInterface;
use Bespin\DocumentType\DocumentType;
use DateTime;

class DatevWageJournalAnnual extends Document
{
    public function __construct(FileInterface $document, int $ownerId, DateTime $contentDate)
    {
        $title = 'Lohnjournal Jahresübersicht '.$contentDate->format('Y');
        parent::__construct($document, $ownerId);
        $this->setReference($title);
        $this->setSender('DATEV');
        $this->setDocumentType(DocumentType::DATEV_WAGE_JOURNAL_ANNUAL);
        $this->setDocumentDate($document->getDocumentDate());
    }
}
