<?php

namespace Bespin\ConfigurationProfile\Payload\VPN\Type\IKEv2;

class SecurityParameters
{
    /**
     * @param string|null $encryptionAlgorithm Optional. One of: [DES, 3DES, AES-128, AES-256 (Default), AES-128-GCM (16-octet ICV), AES-256-GCM (16-octet ICV)].
     * @param string|null $integrityAlgorithm Optional. One of: [SHA1-96, SHA1-160, SHA2-256 (Default), SHA2-384, SHA2-512].
     * @param int|null $diffieHellmanGroup Optional. One of: [1, 2, 5, 14 (Default), 15, 16, 17, 18, 19, 20, or 21].
     * @param int|null $lifeTimeInMinutes Optional. SA lifetime (rekey interval) in minutes. Valid values are 10 through 1440. Defaults to 1440 minutes.
     */
    public function __construct(
        private readonly ?string $encryptionAlgorithm = null,
        private readonly ?string $integrityAlgorithm = null,
        private readonly ?int    $diffieHellmanGroup = null,
        private readonly ?int    $lifeTimeInMinutes = null
    )
    {

    }

    public function getParameters(): object
    {

        return (object)[
            'DiffieHellmanGroup'  => $this->diffieHellmanGroup ?? 14,
            'EncryptionAlgorithm' => $this->encryptionAlgorithm ?? 'AES-256',
            'IntegrityAlgorithm'  => $this->integrityAlgorithm ?? 'SHA2-256',
            'LifeTimeInMinutes'   => $this->lifeTimeInMinutes ?? 1440,
        ];
    }
}
