<?php

namespace Bespin\ConfigurationProfile\Payload\Security;

use Bespin\ConfigurationProfile\Helper\Data;
use Bespin\ConfigurationProfile\Helper\UUID;
use Bespin\ConfigurationProfile\Payload\PayloadInterface;
use Bespin\ConfigurationProfile\ConfigurationProfile;

class PKCS12 implements PayloadInterface
{
    private readonly string $uuid;

    public function __construct(
        private readonly string $name,
        private readonly string $pkcs12,
        private readonly string $description = 'PKCS#12-formatted certificate'
    )
    {
        $this->uuid = UUID::get();
    }

    public function getPayload(): object
    {
        return (object)[
            'PayloadCertificateFileName' => $this->name.'.p12',
            'PayloadContent'             => new Data($this->pkcs12),
            'PayloadDescription'         => $this->description,
            'PayloadDisplayName'         => $this->name,
            'PayloadIdentifier'          => 'com.apple.security.pkcs12.'.$this->uuid,
            'PayloadType'                => 'com.apple.security.pkcs12',
            'PayloadUUID'                => $this->uuid,
            'PayloadVersion'             => 1,
        ];
    }

    public function setConfigurationProfile(ConfigurationProfile $mobileConfig): void
    {
    }

    public function getUUID(): string
    {
        return $this->uuid;
    }
}
