<?php

namespace Bespin\ConfigurationProfile\Payload\VPN\Type;

use Bespin\ConfigurationProfile\ConfigurationProfile;
use Bespin\ConfigurationProfile\Payload\VPN\Type\IKEv2\SecurityParameters;
use Bespin\ConfigurationProfile\Payload\VPN\TypeInterface;

class IKEv2 implements TypeInterface
{
    private ?ConfigurationProfile $mobileConfig = null;

    /**
     * @param string $remoteAddress Required. IP address or hostname of the VPN server.
     * @param string $localIdentifier Required. Identifier of the IKEv2 client in one of the following formats: FQDN / UserFQDN / Address / ASN1DN
     * @param SecurityParameters $childSecurityAssociationParameters
     * @param SecurityParameters $ikeSecurityAssociationParameters
     */
    public function __construct(
        private readonly string             $remoteAddress,
        private readonly string             $remoteIdentifier,
        private readonly string             $localIdentifier,
        private readonly SecurityParameters $childSecurityAssociationParameters,
        private readonly SecurityParameters $ikeSecurityAssociationParameters,
    )
    {
    }

    public function getPayload(): object
    {
        return (object)[
            'AuthenticationMethod'                      => 'Certificate',
            'ChildSecurityAssociationParameters'        => $this->childSecurityAssociationParameters->getParameters(),
            'DeadPeerDetectionRate'                     => 'Low',
            'DisableMOBIKE'                             => 0,
            'DisableRedirect'                           => 0,
            'EnableCertificateRevocationCheck'          => 0,
            'EnablePFS'                                 => true,
            'IKESecurityAssociationParameters'          => $this->ikeSecurityAssociationParameters->getParameters(),
            'LocalIdentifier'                           => $this->localIdentifier,
            'PayloadCertificateUUID'                    => $this->mobileConfig?->getCertificateUUID(),
            'RemoteAddress'                             => $this->remoteAddress,
            'RemoteIdentifier'                          => $this->remoteIdentifier,
            'UseConfigurationAttributeInternalIPSubnet' => 0,
        ];
    }

    public function getKey(): string
    {
        return 'IKEv2';
    }

    public function getType(): string
    {
        return 'IKEv2';
    }

    public function setMobileConfig(ConfigurationProfile $mobileConfig): void
    {
        $this->mobileConfig = $mobileConfig;
    }
}
