<?php

namespace Bespin\ConfigurationProfile\Payload\Security;

use Bespin\ConfigurationProfile\Helper\Data;
use Bespin\ConfigurationProfile\Helper\UUID;
use Bespin\ConfigurationProfile\Payload\PayloadInterface;
use Bespin\ConfigurationProfile\ConfigurationProfile;

class Root implements PayloadInterface
{
    private readonly string $uuid;

    public function __construct(
        private readonly string $name,
        private readonly string $caCert,
        private readonly string $description = 'CA root certificate'
    )
    {
        $this->uuid = UUID::get();
    }

    public function getPayload(): object
    {
        return (object)[
            'PayloadCertificateFileName' => $this->name.'.der',
            'PayloadContent'             => new Data($this->caCert),
            'PayloadDescription'         => $this->description,
            'PayloadDisplayName'         => $this->name,
            'PayloadIdentifier'          => 'com.apple.security.root.'.$this->uuid,
            'PayloadType'                => 'com.apple.security.root',
            'PayloadUUID'                => $this->uuid,
            'PayloadVersion'             => 1,
        ];
    }

    public function setConfigurationProfile(ConfigurationProfile $mobileConfig): void
    {
    }
}
