<?php

namespace Bespin\ConfigurationProfile\Payload\VPN\Modules;

use Bespin\ConfigurationProfile\Payload\VPN\ModuleInterface;

class DNS implements ModuleInterface
{
    public function __construct(private readonly array $searchDomains)
    {

    }

    public function getPayload(): object
    {
        return (object)[
            'SearchDomains' => $this->searchDomains
        ];
    }

    public function getKey(): string
    {
        return 'DNS';
    }
}
