<?php

namespace Bespin\ConfigurationProfile\Payload\VPN;

use Bespin\ConfigurationProfile\Helper\UUID;
use Bespin\ConfigurationProfile\Payload\PayloadInterface;
use Bespin\ConfigurationProfile\ConfigurationProfile;

class Managed implements PayloadInterface
{
    private string $uuid;
    /** @var ModuleInterface[] */
    private array                 $modules      = [];
    private ?ConfigurationProfile $mobileConfig = null;

    public function __construct(
        private readonly string        $vpnConnectionName,
        private readonly TypeInterface $type
    )
    {
        $this->uuid = UUID::get();
    }

    public function addModule(ModuleInterface $module)
    {
        $this->modules[] = $module;
    }

    public function getPayload(): object
    {
        $this->type->setMobileConfig($this->mobileConfig);
        $payload = [
            'PayloadDescription'  => 'Configures VPN settings',
            'PayloadDisplayName'  => 'VPN Settings',
            'PayloadIdentifier'   => 'com.apple.vpn.managed.'.$this->uuid,
            'PayloadType'         => 'com.apple.vpn.managed',
            'PayloadUUID'         => $this->uuid,
            'PayloadVersion'      => 1.0,
            'UserDefinedName'     => $this->vpnConnectionName,
            'PayloadOrganization' => $this->mobileConfig?->getOrganization() ?? '',
            'VPNType'             => $this->type->getType(),
            $this->type->getKey() => $this->type->getPayload()
        ];
        foreach ($this->modules as $module) {
            $payload[$module->getKey()] = $module->getPayload();
        }
        return (object)$payload;
    }

    public function setConfigurationProfile(ConfigurationProfile $mobileConfig): void
    {
        $this->mobileConfig = $mobileConfig;
    }
}
