<?php

namespace Bespin\Auth\Authentication;

class User
{

    /**
     * @var array<string|array<string>>
     */
    private array $attributes = [];

    public function __construct(object $idToken)
    {
        foreach (CognitoProperties::cases() as $property) {
            $value = $idToken->{$property->value} ?? null;
            if ($property === CognitoProperties::email) {
                $value = strtolower($value);
            }
            $this->attributes[$property->name] = $value;
        }
    }

    /**
     * @return array<string|array<string>
     */
    public function getAttributes(): array
    {
        return $this->attributes;
    }

    public function getAttribute(CognitoProperties $property): null|string|array
    {
        return $this->attributes[$property->name] ?? null;
    }
}