<?php

namespace Bespin\Auth\Authentication\Model;

class Helper
{
    /**
     * returns a string to be used in the SET part of an UPDATE statement like: key1=:key1, key2=:key2, key3=:key3
     * @param array<string, string> $columns
     * @return string
     */
    public static function set(array $columns): string
    {
        return implode(
            ', ',
            array_map(
                function ($column) {
                    return $column.'=:'.$column;
                },
                array_keys($columns)
            )
        );
    }

    /**
     * returns a string to be used in the column part of INSERT statements like: key1, key2, key3
     * @param array<string, string> $columns
     * @return string
     */
    public static function insertColumns(array $columns): string
    {
        return implode(', ', array_keys($columns));
    }

    /**
     * returns a string to be used in the VALUES part of INSERT statements like: :key1, :key2, :key3
     * @param array<string, string> $columns
     * @return string
     */
    public static function insertValues(array $columns): string
    {
        return ':'.implode(', :', array_keys($columns));
    }

    /**
     * returns a string to be used in WHERE constraints like: key1=:key1 AND key2=:key2
     * @param array<string, string> $columns
     * @param string $type
     * @return string
     */
    public static function where(array $columns, string $type = 'AND'): string
    {
        return implode(
            ' '.$type.' ',
            array_map(
                function ($column) {
                    return $column.'=:'.$column;
                },
                array_keys($columns)
            )
        );
    }


    /**
     * merges associative arrays. Values for the same index will be overwritten from the first to the last argument
     * @param array<string, string> ...$array
     * @return array
     */
    public static function push(array ...$array): array
    {
        if (empty($array)) {
            return [];
        }
        reset($array);
        $firstIndex = key($array);
        $firstArray = $array[$firstIndex];
        unset($array[$firstIndex]);
        foreach ($array as $remainingArrays) {
            foreach ($remainingArrays as $key => $value) {
                $firstArray[$key] = $value;
            }
        }
        return $firstArray;
    }

}
