<?php

namespace Bespin\Auth\Authentication;

use Firebase\JWT\JWT;

class Cognito
{
    const ID_TOKEN = 'id_token';

    public static function getIdToken()
    {
        if (isset($_SERVER['QUERY_STRING'])) {
            parse_str($_SERVER['QUERY_STRING'], $query);
            if (isset($query[self::ID_TOKEN])) {
                return $query[self::ID_TOKEN];
            }
        }
        return false;
    }

    public static function getDecodedIdToken(string $idToken): ?object
    {
        $tks = explode('.', $idToken);
        if (count($tks) === 3) {
            return JWT::jsonDecode(JWT::urlsafeB64Decode($tks[1]));
        }
        return null;
    }
}