<?php

namespace Bespin\Calendar;

use DateInterval;
use DateTime;
use DateTimeZone;

readonly class Event
{
    public function __construct(private string $uid, private string $title, private DateTime $start, private DateTime $end, private string $email = '', private string $name = '', private string $description = '')
    {
    }

    public function createICalObject(): string
    {
        $icsContent = "BEGIN:VCALENDAR\r\n";
        $icsContent .= "VERSION:2.0\r\n";
        $icsContent .= "PRODID:-//Herd//Portal//EN\r\n";
        $icsContent .= "BEGIN:VEVENT\r\n";
        $icsContent .= 'UID:'.$this->uid."\r\n";
        $icsContent .= 'DTSTAMP:'.(new DateTime())->setTimezone(new DateTimeZone('UTC'))->format('Ymd\THis\Z')."\r\n";
        $icsContent .= 'DTSTART;VALUE=DATE:'.$this->start->format('Ymd')."\r\n";
        $icsContent .= 'DTEND;VALUE=DATE:'.$this->end->add(new DateInterval('P1D'))->format('Ymd')."\r\n";
        $icsContent .= 'SUMMARY:'.$this->escapeString($this->title)."\r\n";
        $icsContent .= 'DESCRIPTION:'.$this->escapeString($this->description)."\r\n";
        $icsContent .= 'ORGANIZER;CN='.$this->escapeString($this->name).':MAILTO:'.$this->escapeString($this->email)."\r\n";
        $icsContent .= "END:VEVENT\r\n";
        $icsContent .= "END:VCALENDAR\r\n";

        return $icsContent;
    }

    private function escapeString(string $value): string
    {
        return str_replace(["\r", "\n", ',', ';'], ['\r', '\n', '\,', '\;'], $value);
    }
}